/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.objects.blocks.BlockCharcoalPile;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.blocks.wood.BlockLogPile;
import net.dries007.tfc.objects.te.TEInventory;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TELogPile
extends TEInventory
implements ITickable {
    private static final int NUM_SLOTS = 4;
    private boolean burning = false;
    private long startBurningTick = 0L;
    private boolean isContainerOpen;

    public TELogPile() {
        super(4);
    }

    public void setContainerOpen(boolean containerOpen) {
        this.isContainerOpen = containerOpen;
        this.setAndUpdateSlots(-1);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 4; ++i) {
                if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
                super.setAndUpdateSlots(slot);
                return;
            }
            if (!this.isContainerOpen) {
                this.field_145850_b.func_175698_g(this.field_174879_c);
            }
        }
        super.setAndUpdateSlots(slot);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.startBurningTick = nbt.func_74763_f("startBurningTick");
        this.burning = nbt.func_74767_n("burning");
        super.func_145839_a(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("startBurningTick", this.startBurningTick);
        nbt.func_74757_a("burning", this.burning);
        return super.func_189515_b(nbt);
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.burning && this.field_145850_b.func_175625_s(this.field_174879_c) == this;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.burning) {
                if ((int)(CalendarTFC.PLAYER_TIME.getTicks() - this.startBurningTick) > ConfigTFC.Devices.CHARCOAL_PIT.ticks) {
                    this.createCharcoal();
                }
            } else if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c() == Blocks.field_150480_ab) {
                this.burning = true;
                this.startBurningTick = CalendarTFC.PLAYER_TIME.getTicks();
            }
        }
    }

    @Override
    public int getSlotLimit(int slot) {
        return 4;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return OreDictionaryHelper.doesStackMatchOre(stack, "logWood");
    }

    public boolean insertLog(ItemStack stack) {
        stack.func_190920_e(1);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!this.inventory.insertItem(i, stack, false).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public int insertLogs(ItemStack stack) {
        int start = stack.func_190916_E();
        for (int i = 0; i < this.inventory.getSlots() && !(stack = this.inventory.insertItem(i, stack, false)).func_190926_b(); ++i) {
        }
        int remaining = stack.func_190926_b() ? 0 : stack.func_190916_E();
        return start - remaining;
    }

    public ItemStack getLog() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            return this.inventory.getStackInSlot(i);
        }
        return ItemStack.field_190927_a;
    }

    public void light() {
        this.burning = true;
        this.startBurningTick = CalendarTFC.PLAYER_TIME.getTicks();
        this.tryLightNearby();
        this.func_70296_d();
    }

    public int countLogs() {
        int logs = 0;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            logs += this.inventory.getStackInSlot(i).func_190916_E();
        }
        return logs;
    }

    private void tryLightNearby() {
        for (EnumFacing side : EnumFacing.values()) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(side));
            if (!(state.func_177230_c() instanceof BlockLogPile) || ((Boolean)state.func_177229_b((IProperty)ILightableBlock.LIT)).booleanValue()) continue;
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177972_a(side), state.func_177226_a((IProperty)ILightableBlock.LIT, (Comparable)Boolean.valueOf(true)));
            TELogPile tile = Helpers.getTE((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(side), TELogPile.class);
            if (tile == null) continue;
            tile.light();
        }
    }

    private void createCharcoal() {
        Block block;
        int j = 0;
        do {
            if (!((block = this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(++j)).func_177230_c()) instanceof BlockLogPile)) continue;
            return;
        } while (block == Blocks.field_150350_a || block instanceof BlockCharcoalPile);
        double logs = (double)this.countLogs() * (0.25 + 0.25 * (double)Constants.RNG.nextFloat());
        int charcoal = (int)MathHelper.func_151237_a((double)logs, (double)0.0, (double)8.0);
        if (charcoal == 0) {
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
            return;
        }
        if (j == 1) {
            this.field_145850_b.func_175656_a(this.field_174879_c, BlocksTFC.CHARCOAL_PILE.func_176223_P().func_177226_a((IProperty)BlockCharcoalPile.LAYERS, (Comparable)Integer.valueOf(charcoal)));
            return;
        }
        for (int k = j - 1; k >= 0; --k) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(k));
            if (state.func_177230_c() == Blocks.field_150350_a) {
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177979_c(k), BlocksTFC.CHARCOAL_PILE.func_176223_P().func_177226_a((IProperty)BlockCharcoalPile.LAYERS, (Comparable)Integer.valueOf(charcoal)));
                this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
                return;
            }
            if (state.func_177230_c() instanceof BlockCharcoalPile) {
                int toCreate = Math.min(charcoal += ((Integer)state.func_177229_b((IProperty)BlockCharcoalPile.LAYERS)).intValue(), 8);
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177979_c(k), BlocksTFC.CHARCOAL_PILE.func_176223_P().func_177226_a((IProperty)BlockCharcoalPile.LAYERS, (Comparable)Integer.valueOf(toCreate)));
                charcoal -= toCreate;
            }
            if (charcoal > 0) continue;
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
            return;
        }
        this.field_145850_b.func_175656_a(this.field_174879_c, BlocksTFC.CHARCOAL_PILE.func_176223_P().func_177226_a((IProperty)BlockCharcoalPile.LAYERS, (Comparable)Integer.valueOf(charcoal)));
    }
}

